/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.client.Scissors;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.impl.client.CottonScreenImpl;
import io.github.cottonmc.cotton.gui.impl.client.MouseInputHandler;
import io.github.cottonmc.cotton.gui.impl.client.NarrationHelper;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_308;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_6382;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class CottonInventoryScreen<T extends SyncedGuiDescription>
extends class_465<T>
implements CottonScreenImpl {
    protected SyncedGuiDescription description;
    @Nullable
    protected WWidget lastResponder = null;
    private final MouseInputHandler<CottonInventoryScreen<T>> mouseInputHandler = new MouseInputHandler<CottonInventoryScreen>(this);

    public CottonInventoryScreen(T description, class_1661 inventory) {
        this(description, inventory, (class_2561)new class_2585(""));
    }

    public CottonInventoryScreen(T description, class_1661 inventory, class_2561 title) {
        super(description, inventory, title);
        this.description = description;
        this.field_22789 = 162;
        this.field_22790 = 162;
        this.field_2792 = 162;
        this.field_2779 = 162;
        ((SyncedGuiDescription)description).getRootPanel().validate((GuiDescription)description);
    }

    public CottonInventoryScreen(T description, class_1657 player) {
        this(description, player.method_31548());
    }

    public CottonInventoryScreen(T description, class_1657 player, class_2561 title) {
        this(description, player.method_31548(), title);
    }

    public void method_25426() {
        super.method_25426();
        this.field_22787.field_1774.method_1462(true);
        WPanel root = this.description.getRootPanel();
        if (root != null) {
            root.addPainters();
        }
        this.description.addPainters();
        this.reposition(this.field_22789, this.field_22790);
    }

    public void method_25432() {
        super.method_25432();
        this.field_22787.field_1774.method_1462(false);
        VisualLogger.reset();
    }

    @Override
    @ApiStatus.Internal
    public GuiDescription getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public WWidget getLastResponder() {
        return this.lastResponder;
    }

    @Override
    public void setLastResponder(@Nullable WWidget lastResponder) {
        this.lastResponder = lastResponder;
    }

    private void clearPeers() {
        this.description.field_7761.clear();
    }

    protected void reposition(int screenWidth, int screenHeight) {
        WPanel basePanel = this.description.getRootPanel();
        if (basePanel != null) {
            this.clearPeers();
            basePanel.validate(this.description);
            this.field_2792 = basePanel.getWidth();
            this.field_2779 = basePanel.getHeight();
            if (this.field_2792 < 16) {
                this.field_2792 = 300;
            }
            if (this.field_2779 < 16) {
                this.field_2779 = 300;
            }
        }
        this.field_25267 = this.description.getTitlePos().x();
        this.field_25268 = this.description.getTitlePos().y();
        if (!this.description.isFullscreen()) {
            this.field_2776 = screenWidth / 2 - this.field_2792 / 2;
            this.field_2800 = screenHeight / 2 - this.field_2779 / 2;
        } else {
            this.field_2776 = 0;
            this.field_2800 = 0;
            if (basePanel != null) {
                basePanel.setSize(screenWidth, screenHeight);
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25400(char ch, int keyCode) {
        if (this.description.getFocus() == null) {
            return false;
        }
        this.description.getFocus().onCharTyped(ch);
        return true;
    }

    public boolean method_25404(int ch, int keyCode, int modifiers) {
        if (ch == 256 || ch == 258) {
            return super.method_25404(ch, keyCode, modifiers);
        }
        if (this.description.getFocus() == null) {
            return super.method_25404(ch, keyCode, modifiers);
        }
        this.description.getFocus().onKeyPressed(ch, keyCode, modifiers);
        return true;
    }

    public boolean method_16803(int ch, int keyCode, int modifiers) {
        if (this.description.getFocus() == null) {
            return false;
        }
        this.description.getFocus().onKeyReleased(ch, keyCode, modifiers);
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        boolean result = super.method_25402(mouseX, mouseY, mouseButton);
        int containerX = (int)mouseX - this.field_2776;
        int containerY = (int)mouseY - this.field_2800;
        if (containerX < 0 || containerY < 0 || containerX >= this.field_22789 || containerY >= this.field_22790) {
            return result;
        }
        this.mouseInputHandler.onMouseDown(containerX, containerY, mouseButton);
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        super.method_25406(mouseX, mouseY, mouseButton);
        int containerX = (int)mouseX - this.field_2776;
        int containerY = (int)mouseY - this.field_2800;
        this.mouseInputHandler.onMouseUp(containerX, containerY, mouseButton);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        super.method_25403(mouseX, mouseY, mouseButton, deltaX, deltaY);
        int containerX = (int)mouseX - this.field_2776;
        int containerY = (int)mouseY - this.field_2800;
        this.mouseInputHandler.onMouseDrag(containerX, containerY, mouseButton, deltaX, deltaY);
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.description.getRootPanel() == null) {
            return super.method_25401(mouseX, mouseY, amount);
        }
        int containerX = (int)mouseX - this.field_2776;
        int containerY = (int)mouseY - this.field_2800;
        this.mouseInputHandler.onMouseScroll(containerX, containerY, amount);
        return true;
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.description.getRootPanel() == null) {
            return;
        }
        int containerX = (int)mouseX - this.field_2776;
        int containerY = (int)mouseY - this.field_2800;
        this.mouseInputHandler.onMouseMove(containerX, containerY);
    }

    protected void method_2389(class_4587 matrices, float partialTicks, int mouseX, int mouseY) {
    }

    private void paint(class_4587 matrices, int mouseX, int mouseY) {
        WPanel root;
        this.method_25420(matrices);
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            GL11.glEnable((int)3089);
            Scissors.refreshScissors();
            root.paint(matrices, this.field_2776, this.field_2800, mouseX - this.field_2776, mouseY - this.field_2800);
            GL11.glDisable((int)3089);
            Scissors.checkStackIsEmpty();
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        WWidget hitChild;
        WPanel root;
        this.paint(matrices, mouseX, mouseY);
        super.method_25394(matrices, mouseX, mouseY, partialTicks);
        class_308.method_24210();
        if (this.description != null && (root = this.description.getRootPanel()) != null && (hitChild = root.hit(mouseX - this.field_2776, mouseY - this.field_2800)) != null) {
            hitChild.renderTooltip(matrices, this.field_2776, this.field_2800, mouseX - this.field_2776, mouseY - this.field_2800);
        }
        this.method_2380(matrices, mouseX, mouseY);
        VisualLogger.render(matrices);
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        if (this.description != null && this.description.isTitleVisible()) {
            int width = this.description.getRootPanel().getWidth();
            ScreenDrawing.drawString(matrices, this.method_25440().method_30937(), this.description.getTitleAlignment(), this.field_25267, this.field_25268, width - this.field_25267, this.description.getTitleColor());
        }
    }

    protected void method_37432() {
        WPanel root;
        super.method_37432();
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            root.tick();
        }
    }

    @Override
    public void renderTextHover(class_4587 matrices, @Nullable class_2583 textStyle, int x, int y) {
        this.method_25418(matrices, textStyle, x, y);
    }

    public boolean method_25407(boolean lookForwards) {
        if (this.description != null) {
            this.description.cycleFocus(lookForwards);
        }
        return true;
    }

    protected void method_37056(class_6382 builder) {
        if (this.description != null) {
            NarrationHelper.addNarrations(this.description.getRootPanel(), builder);
        }
    }
}

